/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.animationdp.impl2;

import filenet.sim.animationdp.IVWSIMAnimationCommand;
import filenet.sim.animationdp.IVWSIMAnimationInfo;
import filenet.sim.animationdp.impl2.AnimationCommand;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class AnimationInfo
implements IVWSIMAnimationInfo {
    static final long serialVersionUID = 1L;
    private int m_wcId = -1;
    private ArrayList cmds = null;

    public int getWorkClassID() {
        return this.m_wcId;
    }

    public IVWSIMAnimationCommand[] getCommands() {
        return this.cmds.toArray(new IVWSIMAnimationCommand[0]);
    }

    public void readFromStream(DataInput in) throws IOException {
        String marker = in.readUTF();
        this.m_wcId = in.readInt();
        int count = in.readInt();
        this.cmds = new ArrayList(count);
        while (count-- > 0) {
            AnimationCommand cmd = new AnimationCommand();
            cmd.readFromStream(in);
            this.cmds.add(cmd);
        }
    }

    public void toString(StringBuffer buf) {
        buf.append("\nANIMATION COMMAND: wcId=").append(this.m_wcId);
        Iterator iter = this.cmds.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
        }
    }

    protected int getToStringSize() {
        return 32 + this.cmds.size() * 64;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getToStringSize());
        this.toString(buf);
        return buf.toString();
    }

    public void writeToStream(DataOutput out) throws IOException {
        out.writeUTF("A_INFO.1.0");
        out.writeInt(this.m_wcId);
        out.writeInt(this.cmds.size());
        Iterator iter = this.cmds.iterator();
        while (iter.hasNext()) {
            ((AnimationCommand)iter.next()).writeToStream(out);
        }
    }
}

